unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    procedure ProcuraArquivos(NomeArq : String);
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    if Edit1.Text = '' then
      ProcuraArquivos('c:\*.*')
    else
      ProcuraArquivos(Edit1.Text);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TForm1.ProcuraArquivos(NomeArq: String);
var
  Diretorio,Nome : String;
  SearchRec : TSearchRec;
  ListaDirs : TStringList;
  Done : Integer;
  i : Integer;
begin
// guarda nome do diretorio
  Diretorio := ExtractFilePath(NomeArq);
// guarda nome do arquivo
  Nome := ExtractFileName(NomeArq);
  Done := FindFirst(NomeArq,0,SearchRec);
  while Done = 0 do begin
// encontrou - adiciona na listbox
    Listbox1.Items.Add(Diretorio+SearchRec.Name);
// procura proximo arquivo
    Done := FindNext(SearchRec);
  end;
  FindClose(SearchRec);
  ListaDirs := TStringList.Create;
  try
// procura subdiretorios
    Done := FindFirst(Diretorio+'*.*',faDirectory,SearchRec);
    while Done = 0 do begin
// testa para ver se e diretorio e se e valido
      if ((SearchRec.Attr and faDirectory) <> 0) and
         (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
        ListaDirs.Add(Diretorio+SearchRec.Name);
      Done := FindNext(SearchRec);
    end;
    FindClose(SearchRec);
// pesquisa em todos diretorios encontrados    
    for i := 0 to ListaDirs.Count-1 do
      ProcuraArquivos(ListaDirs[i]+'\'+Nome);
  finally
    ListaDirs.Free;
  end;
end;

end.
